// bergmark - Spring 1999 - ITX project

// PhoneRecorder is an ITX application that lets you use your telephone
// to record a message to file, perhaps for later retrieval.

// Instructions for running:
//    jview PhoneRecorder
//    [ 
//      Make sure there is no "file1" in your Current Working Directory
//      Make sure there IS a "resolv.conf" in your Current Working Directory
//      Pick up your telephone and dial 45522 
//      After James' message, type in 10018#
//      Record a message, using the mouthpiece on your telephone; it
//         will appear on the disk as "file1" 
//      Hangup
//    ]

package cnrg.apps.PhoneFiles;

import java.io.*; // for OutputStream

import cnrg.itx.signal.*;         // for DesktopSignaling
import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.datax.devices.*;  // for AudioConnection, etc.
import cnrg.itx.datax.*;          // for Channel

public class PhoneRecorder extends AbstractSignalingObserver {

   private final String ME = "HandsetRecorder ";
   private final boolean LOG = true;

   private DesktopSignaling myDS = null;
   private FileOutputStream ourFile = null;

   private NetworkSource source = null;
   private StreamDestination dest = null;

   // Default constructor
   public PhoneRecorder () {
      try {
         myDS = new DesktopSignaling ( this, "PhoneRecorder", "password");
      } catch ( Exception e ) {
	 System.out.println ("Could not get a DesktopSignaling because " +
	    e.toString() );
	 System.exit( 0 );
      }
   }

   public static void main ( String[] args ) {
      PhoneRecorder me = new PhoneRecorder();
   }

   // +++++  SignalingObserver methods +++++++++++++

   public void onInvite (InviteSignalEvent ise) {
      Connection c = null;
      Channel in = new Channel();     // This will be telephone to file

      if ( LOG ) System.out.println ( ME + "has an invitation");

      // TO DO: determine if caller has sound capabilities by examining
      // properties

      // Get a name for the output file
      try {
         ourFile = new FileOutputStream ( getName() );
      } catch ( Exception e ) {
	 System.out.println (ME + "could not open the destination output " +
            " file because " + e.toString() );
	 System.exit( 0 );
      }

      try {
	 source = new NetworkSource(in, SpeakerDestination.SAMPLE_SIZE);
         in.setSource ( source );
	 dest = new StreamDestination(ourFile);
         in.addDestination ( dest );
         c = new AudioConnection ( in, null );
      } catch ( Exception e ) {
	 System.out.println ("Could not set up the AudioConnection because " +
	    e.toString() );
	 System.exit( 0 );
      }

      // If we get to here, we have an open data connection
      if ( LOG ) System.out.println(ME + "opened a data connection");
      ise.accept( c );  // accept the call, passing in our connection

      // Exit back to our DesktopSignaling, which should send the
      // Accept package back to the Gateway

   }

   /**
    * This method is invoked when the gateway has confirmed our accept.
    * The gateway's end of the connection is open.  Open ours and go.
    */
   public void onStartCall ( SignalConnection c ) {
      try {
         c.open();
      } catch ( Exception e ) {
	 System.out.println ("Could not open the AudioConnection because " +
	    e.toString() );
	 System.exit( 0 );
      }
   }

   // This method is invoked when the caller hangs up.
   public void onHangup(HangupSignalEvent hse) {
      if ( LOG ) System.out.println ( ME + "got hangup ... close the file "
	 + " and log out");   // TBD: actually just stop this thread
      try {
         ourFile.flush();
         ourFile.close();
      } catch ( Exception e ) {}
      System.out.println ( ME + " Statistics: ");
      System.out.println ( source.getStatistics() );
      System.out.println ( dest.getStatistics() );
      myDS.logout();
   }

   // +++++++++++  Private methods +++++++++++++++++=

   // Generate a file name to capture the data
   private String getName () {
      return "file1";
   }
}

